// Globale Annahmen:
// ACHTUNG diese globalen Annahmen sind extrem wichtig bei der
// Konstruktion der Pattern. Dieser Kommentarblock ist daher unbedingt auf
// dem aktuellen Stand zu halten!
// Summationsvariable: k
// Variable der ztrans: z
// Do not use k0 as pattern variable !!!
// a, b, c, ..., v, w, x, y sind von k unabhngig
// m, n, m0, n0 positiv und ganzzahlig
// m2, n2 positiv, ganzzahlig, gerade
// m1, n1 positiv, ganzzahlig, ungerade
// m3, n3 ganzzahlig
// fx, gx, f1x, g1x are unrestricted

// Diese Datei wird aus compile_patterns.mu heraus gelesen.

//------------------------------------------------------------
// We need a symbolic heaviside(0) for the patterns. Otherwise, 
// the pattern matcher always use the predefined heaviside(0) 
// = 1/2, even if the user defines his own value.
//------------------------------------------------------------
heaviside(0):
sysdelete(heaviside(0)):
alias(bl=matchlib::block):
alias(mysubs= transform::ztrans::evalAtPoint):
alias(my_plus=sum::sum_fn):

//------------------------------------------------------------
// Define the patterns:
//------------------------------------------------------------
ztrans_patterns:=
[ 
 //----------
 // pattern 1
 //----------
 [a^(b*k + c)*fx, 
    bl(a^c*transform::ztrans(fx, k, z/a^b)),
    [bl(not iszero(b)), bl(not iszero(a-1))]],
 //----------
 // pattern 2
 //----------
 [k^a*fx, 
    bl(transform::ztrans::mult2diff(transform::ztrans(fx, k, z), z, a)),
    [bl(testtype(a,Type::PosInt))]],

 [(b*k + c)^a*fx, 
  bl(my_plus((r ->
               binomial(a, r)*b^r*c^(a-r)*
               transform::ztrans::mult2diff(transform::ztrans(fx, k, z), z, r)
             ), 0..a)),
  [bl(not iszero(b)), bl(a > 0), bl(testtype(a, DOM_INT))]
 ],
 //----------
 // pattern 3
 //----------
 [1, z/(z-1)],
 //----------
 // pattern 4
 //----------
 [a^(b*k + c), a^c*z/(z-a^b),
    [bl(not iszero(b))]],
 //----------
 // pattern 5
 //----------
 [(-1)^(k + c)*a^(k + b), (-1)^c*a^b*z/(z + a)],
 //----------
 // pattern 6
 //----------
 [k^a, bl((-1)^(a + 1)*polylog(-a, z)), [a in Z_, a >= 0]],

 [(b*k + c)^a, 
  bl(my_plus((r -> (binomial(a, r)*b^r*c^(a-r)*(-1)^(r+1)*polylog(-r, z) )) , 0..a)),
  [bl(not iszero(b)), a >= 0, a in Z_]
 ],
 // -------------------------------------------------------
 // pattern7: heaviside(k - k0)
 // -------------------------------------------------------
 /*
 // the following two patterns are included in
 // the patterns below as fx(k) = 1:
 [heaviside(a*k + b), 
    bl(piecewise([b <=0, z/(z - 1)/z^ceil(-b/a)],
                 [b > 0, z/(z - 1)] )),
    [a > 0 and not b/a in Z_]],

 [heaviside(a*k + b), 
    bl(piecewise([b <=0, heaviside(0)*z^(b/a)
                       + 1/(z - 1)*z^(b/a)],
                 [b > 0, z/(z - 1)] )),
    [a > 0 and b/a in Z_]],
 */

 [heaviside(a*k + b)*fx, 
    bl(transform::ztrans(mysubs(fx, k, k+ceil(-b/a)),k,z)/z^ceil(-b/a)),
    [a > 0, not b/a in Z_, b <= 0]],

 [heaviside(a*k + b)*fx, 
    bl(transform::ztrans(fx, k, z)),
    [a > 0,  not b/a in Z_, b > 0]],

 [heaviside(a*k + b)*fx, 
    bl(heaviside(0)*mysubs(fx, k , -b/a)*z^(b/a)
       +transform::ztrans(mysubs(fx, k, k-b/a + 1),k,z)*z^(b/a - 1)),
    [a > 0, b/a in Z_, b <= 0]],

 [heaviside(a*k + b)*fx, 
    bl(transform::ztrans(fx, k, z)),
    [a > 0, b/a in Z_, b > 0]],

 // -------------------------------------------------------
 // pattern8: heaviside(k0 - k)
 // -------------------------------------------------------
 //-------------------------------------------------------------
 // With c = 2*heaviside(0) -1, we have
 // heaviside(-k) = c*kroneckerDelta(k, 0) + 1 - heaviside(k),
 // i.e.,
 // ztrans(heaviside(-k),k,z) = c + z/(z-1) - ztrans(heaviside(k),k,z)
 // So use the branch a > 0 above to derive the results for the
 // branch a < 0 below:
 // heaviside(a*k+b) = c*kroneckerDelta(a*k+b, 0) + 1
 //                     - heaviside((-a)*k + (-b))
 //-------------------------------------------------------------
 [heaviside(a*k + b)*fx, 
    bl(transform::ztrans(fx, k, z)
       - transform::ztrans(mysubs(fx, k, k+ceil(-b/a)),k,z)/z^ceil(-b/a)),
    [a < 0, b >= 0, not b/a in Z_]],
 [heaviside(a*k + b)*fx, 
    bl(0),
    [a < 0, b < 0, not b/a in Z_]],
 [heaviside(a*k + b)*fx, 
    bl(transform::ztrans(fx, k, z)
       + heaviside(0)*mysubs(fx, k , -b/a)*z^(b/a)
       - transform::ztrans(mysubs(fx, k, k-b/a),k,z)*z^(b/a)),
    [a < 0, b >= 0, b/a in Z_]],
 [heaviside(a*k + b)*fx, 
    bl(0),
    [a < 0, b < 0, b/a in Z_]],
 //-----------------------------------------
 // pattern 9: kroneckerDelta
 //-----------------------------------------
/*
 [fx*hold(kroneckerDelta)(a*k, b), 
   bl(piecewise([b/a in Z_ and b/a >=0, transform::ztrans::evalAtPoint(fx, k, b/a)/z^(b/a)], 
                [Otherwise, 0])) ],
 [fx*hold(kroneckerDelta)(b, a*k), 
   bl(piecewise([b/a in Z_ and b/a >=0, transform::ztrans::evalAtPoint(fx, k, b/a)/z^(b/a)], 
                [Otherwise, 0])) ],
 [fx*hold(kroneckerDelta)(a*k + b, 0), 
   bl(piecewise([b/a in Z_ and b/a <=0, transform::ztrans::evalAtPoint(fx, k, -b/a)/z^(-b/a)], 
                [Otherwise, 0])) ],
 [fx*hold(kroneckerDelta)(0, a*k + b), 
   bl(piecewise([b/a in Z_ and b/a <=0, transform::ztrans::evalAtPoint(fx, k, -b/a)/z^(-b/a)], 
                [Otherwise, 0])) ],
*/

/*
 [fx*hold(kroneckerDelta)(a*k + b, c*k + d), 
   bl(piecewise([(d - b)/(a - c) in Z_ and (d - b)/(a - c) >=0,
                 transform::ztrans::evalAtPoint(fx, k, (d - b)/(a - c))*z^((b - d)/(a - c))],
                [Otherwise, 0])),
   [bl(not iszero(a - c))]],
 [fx*hold(kroneckerDelta)(0*k + b, c*k + d), 
   bl(piecewise([(d - b)/(0 - c) in Z_ and (d - b)/(0 - c) >=0,
                 transform::ztrans::evalAtPoint(fx, k, (d - b)/(0 - c))*z^((b - d)/(0 - c))],
                [Otherwise, 0])),
   [bl(not iszero(0 - c))]],
 [fx*hold(kroneckerDelta)(a*k + b, 0*k + d),
   bl(piecewise([(d - b)/(a - 0) in Z_ and (d - b)/(a - 0) >=0,
                 transform::ztrans::evalAtPoint(fx, k, (d - b)/(a - 0))*z^((b - d)/(a - 0))],
                [Otherwise, 0])),
   [bl(not iszero(a - 0))]],
*/

 // Eventually we should remove the piecewise here, making two patterns
 // But for the Otherwise case, we then have to formulate the exact
 // conditions. Do we want to have this?
 [fx*hold(kroneckerDelta)(a*k + b, 0), 
   bl(piecewise([-b/a in Z_ and -b/a >= 0,
                 transform::ztrans::evalAtPoint(fx, k, - b/a)*z^(b/a)],
                [Otherwise, 0])),
   [bl(not iszero(a))]],


 //-----------------------------------------
 // various patterns
 //-----------------------------------------
/* !!! */

//=============
// symbolic results: d not DOM_INT
 [binomial(k + d, e), 
  bl(binomial(d, e)*hypergeom([1, 1 + d], [d - e + 1], 1/z)),
   [bl(not testtype(d, DOM_INT) and d>=0 and e<=d)]],
 [binomial(k + d, e), 
  bl(- hold(sum)(binomial(k+d,e)/z^k, k=-d-1..-1) 
     + (-1)^e*z^(1+d)
     + z^(1+d)/(z-1)^(1+e)),
   [bl(not testtype(d, DOM_INT) and d in Z_ and d >= 0 and e > d)]],
 [binomial(k + d, e), 
  bl( hold(sum)(binomial(k+d,e)/z^k, k=0..-d -1) + z^(1+d)/(z-1)^(1+e)),
   [bl(not testtype(d, DOM_INT) and d in Z_ and d < 0 and e >= 0)]],
 [binomial(k + d, e), 
  bl(hold(sum)(binomial(k+d,e)/z^k, k=max(0, e-d) ..-d-1)),
   [bl(not testtype(d, DOM_INT) and e-d in Z_ and d < 0 and e < 0)]],

 [a^(b*k+c)*binomial(k + d, e), 
  bl(a^c*binomial(d, e)*hypergeom([1, 1 + d], [d - e + 1], a^b/z)),
   [bl(not testtype(d, DOM_INT) and d>=0 and e<=d)]],
 [a^(b*k+c)*binomial(k + d, e), 
  bl(-a^c*hold(sum)(binomial(k+d,e)*a^(b*k)/z^k, k=-d-1..-1) 
     +a^c*(-1)^e/a^(b*(1+d))*z^(1+d)
     +a^c/a^(b*(1+d))*z^(1+d)/(z/a^b-1)^(1+e)),
   [bl(not testtype(d, DOM_INT) and d in Z_ and d >= 0 and e > d)]],
 [a^(b*k+c)*binomial(k + d, e), 
  bl( a^c*hold(sum)(binomial(k+d,e)*a^(b*k)/z^k, k=0..-d -1) 
     +a^c/a^(b*(1+d))*z^(1+d)/(z/a^b-1)^(1+e)),
   [bl(not testtype(d, DOM_INT) and d in Z_ and d < 0 and e >= 0)]],
 [a^(b*k+c)*binomial(k + d, e), 
  bl(a^c*hold(sum)(binomial(k+d,e)*a^(b*k)/z^k, k=max(0, e-d) ..-d-1)),
   [bl(not testtype(d, DOM_INT) and e-d in Z_ and d < 0 and e < 0)]],

 //==============================
 // explicit results: d : DOM_INT
 //==============================

 // d >= 0, e >= d
 [binomial(k + d, e), 
  bl(-my_plus((k-> binomial(k+d,e)/z^k),-d..-1) + z^(1+d)/(z-1)^(1+e)),
   [bl(testtype(d, DOM_INT) and d >= 0 and e > d)] ],
 [a^(b*k + c) * binomial(k + d, e), 
  bl(- my_plus((k-> a^(b*k + c)*binomial(k+d, e)/z^k), -d..-1)
     + a^(b*(e - d) + c)*z^(1 + d)/(z - a^b)^(1+e)),
   [bl(testtype(d, DOM_INT) and d >= 0 and e > d)]],

 // d >= 0, e <= d and e >= 0
 [binomial(k + d, e), 
  bl(-my_plus((k-> binomial(k+d,e)/z^k),-d..-1) + z^(1+d)/(z-1)^(1+e)),
   [bl(testtype(d, DOM_INT) and d >= 0 and e >= 0 and e <= d)] ],
 [a^(b*k + c) * binomial(k + d, e), 
  bl(- my_plus((k-> a^(b*k + c)*binomial(k+d, e)/z^k), -d..-1)
     + a^(b*(e - d) + c)*z^(1 + d)/(z - a^b)^(1+e)),
   [bl(testtype(d, DOM_INT) and d >= 0 and e > d)]],

 // d >= 0, e <= d and e < 0
 [binomial(k + d, e), 0,
   [bl(testtype(d, DOM_INT) and d >= 0 and e < 0 and e <= d)] ],
 [a^(b*k + c)*binomial(k + d, e), 0,
   [bl(testtype(d, DOM_INT) and d >= 0 and e < 0 and e <= d)] ],

 // d < 0, e >= 0
 [binomial(k + d, e), 
  bl( my_plus((k-> binomial(k+d,e)/z^k), 0..-d-1) + z^(1+d)/(z-1)^(1+e)),
   [bl(testtype(d, DOM_INT) and d < 0 and e >= 0)] ],
 [a^(b*k + c)*binomial(k + d, e), 
  bl(  a^c*my_plus((k-> binomial(k+d,e)*a^(b*k)/z^k), 0..-d-1) 
     + a^c/a^(b*(1+d))*z^(1+d)/(z/a^b-1)^(1+e)),
   [bl(testtype(d, DOM_INT) and d < 0 and e >= 0)] ],
 
 // d < 0, e < 0
 [binomial(k + d, e), 
  bl(my_plus((k -> binomial(k + d, e)/z^k), max(0,e-d)..-d-1)),
   [bl(testtype(d, DOM_INT) and testtype(e-d, DOM_INT) and d<0 and e<0)] ],
 [a^(b*k + c)*binomial(k + d, e), 
  bl(a^c*my_plus((k -> binomial(k + d, e)*a^(b*k)/z^k), max(0,e-d)..-d-1)),
   [bl(testtype(d, DOM_INT) and testtype(e-d, DOM_INT) and d<0 and e<0)] ],
 [binomial(k + d, e), 
  bl(hold(sum)(binomial(k + d, e)/z^k, k = max(0,e-d)..-d-1)),
   [bl(testtype(d, DOM_INT) and (not testtype(e-d, DOM_INT)) and d<0 and e<0)] ],
 [a^(b*k + c)*binomial(k + d, e), 
  bl(a^c*hold(sum)(binomial(k + d, e)*a^(b*k)/z^k, k = max(0,e-d)..-d-1)),
   [bl(testtype(d, DOM_INT) and (not testtype(e-d, DOM_INT)) and d<0 and e<0)] ],
//===================================

 // patterns for exp(1/z)
 [a^(b*k + c)/(k + d)!, 
   bl(a^c*exp(a^b/z)*(z/a^b)^d* (1 - igamma(d, a^b/z)/gamma(d))),
   [d in Z_, d > 0]
 ],
 [a^(b*k + c)/(k + d)!, 
   bl(a^c*exp(a^b/z)*(z/a^b)^d),
   [d in Z_, d <= 0]
 ],
 [a^(b*k + c)/(k + d)!, 
   bl(a^c*exp(a^b/z)*(z/a^b)^d -my_plus((r -> a^(b*r + c)/(r + d)!/z^r), -d..-1)),
   [d in Z_, d > 0]
 ],
 // some more patterns 
 [sin(a*k + b), 
      z*    sin(a)  *cos(b)/(1 - 2*z*cos(a) + z^2)
    + z*(z - cos(a))*sin(b)/(1 - 2*z*cos(a) + z^2)
 ],
 [cos(a*k + b),  
    z*(z - cos(a))*cos(b)/(1 - 2*z*cos(a) + z^2)
   -z*   sin(a)   *sin(b)/(1 - 2*z*cos(a) + z^2)
 ],
 [sinh(a*k + b), 
    z*(sinh(b)*z + sinh(a-b))/(1 - 2*z*cosh(a) + z^2)
 ],
 [cosh(a*k + b),  
    z*(cosh(b)*z - cosh(a-b))/(1 - 2*z*cosh(a) + z^2)
 ],
 [1/(k + 1/2), 2*arctanh(sqrt(1/z))/sqrt(1/z)],
 null()
]:
