//   

/*++
	invfourier(f,y,x) = 1/(2*PI)*int(f*exp(-I*y*x),y=-infinity..infinity)
	                = 1/(2*PI)*fourier(f,y,-x) 
++*/
transform::invfourier:= proc(f,y,x)
begin
   if args(0) <> 3 then error("expecting three arguments") end_if;
   // allow overloading
   if f::dom::invfourier<>FAIL then 
       // allow overloading:
       return(f::dom::invfourier(args()))
   elif testargs() then
       if type(f) = "_equal" then
           if not testtype(f,Type::Arithmetical=Type::Arithmetical) then
               error("invalid first argument")
           end_if
       elif not testtype(f,Type::Arithmetical) then
           error("the first argument must be of 'Type::Arithmetical'")
       end_if
   end_if;

   return(1/(2*PI)*transform::fourier(f,y,-x))
end_proc:

transform::invfourier:= funcenv(transform::invfourier):
transform::invfourier::interface := {hold(addpattern)}:

transform::invfourier::addpattern:=
loadproc(transform::invfourier::addpattern,
         pathname("TRANS","FOURIER"), "invaddpattern"):


