/*++
 mellin(f(x),x,z) returns the Mellin transform of f(x) wrt z, i.e.
  mellin(f(x), x, z)
  = int(f(x)*x^(z-1),x=0..infinity) 
  = int(f(exp(-t))*exp(-t*z),t=-infinity..infinity)

 Reference: Tables of Mellin transforms, F. Oberhettinger, Springer-Verlag1974
++*/

alias(Match=intlib::match):
alias(_p=_pattern):

transform::mellin := proc(f, x, z) 
 local s, k, ab, b;
 save t, g, c, h, p, n, a;
begin
   delete t, g, c, h, p, n, a;	       
  
   if args(0) = 0 then error("no arguments given") end_if;

   if f::dom::mellin<>FAIL then 
       return(f::dom::mellin(args())) 
   elif testargs() then
      if type(f) = "_equal" then
          if not testtype(f,Type::Arithmetical=Type::Arithmetical) then
              error("invalid 1st argument")
          end_if
      elif not testtype(f,Type::Arithmetical) then
          error("1st argument must be of 'Type::Arithmetical'")
      end_if
   end_if;

   case type(f)
   of "int" do
      if (s:=Match(f,hold(int)(_p(g,not has,x)*x^(-_p(t)),
            _p(t)=_p(c)-I*infinity.._p(c)+I*infinity)))<>FAIL then
         g:=subs(g,op(s)); t:=subs(t,op(s));
         return(2*I*PI*subs(g,t=z)) // formula 1.1 
      elif (s:=Match(f,hold(int)(_p(g)(x*t)
				 *_p(h,not has,x),_p(t)=0..infinity)))<>FAIL
	then
         // formula 1.14, x^alpha and t^beta are already covered by 1.6 
         g:=subs(g,op(s)); t:=subs(t,op(s)); h:=subs(h,op(s));
         return(transform::mellin(g(x),x,z)*transform::mellin(h,t,1-z))
      elif (s:=Match(f,hold(int)(_p(g)(x/t)
				 *_p(h,not has,x),_p(t)=0..infinity)))<>FAIL
	then
         // formula 1.15 
         g:=subs(g,op(s)); t:=subs(t,op(s)); h:=subs(h,op(s));
         return(transform::mellin(g(x),x,z)*transform::mellin(h,t,1+z))
      elif (s:=Match(f,hold(int)(_p(h,not has,x),_p(t)=0..x)))<>FAIL
	then // 1.16 
         h:=subs(h,op(s)); t:=subs(t,op(s)); 
         return(-1/z*transform::mellin(h,t,z+1))
      elif (s:=Match(f,hold(int)(_p(h,not has,x),_p(t)=x..infinity)))<>FAIL
	then // 1.17 
         h:=subs(h,op(s)); t:=subs(t,op(s)); 
         return(1/z*transform::mellin(h,t,z+1))
      end_if; break
   of "function" do
      if nops(f)=1 then
	if (s:=Match(op(f),_p(a,((t) -> (not has(t,x) /* and is(t>0) */ )))
		     *x^_p(p,not has,x)))<>FAIL then
            a:=subs(a,op(s)); p:=subs(p,op(s)); g:=op(f,0);
            if a=1 and p=1 then break end_if; // avoids infinite loops 
            if is(p>0)=TRUE then // 1.6 for v=0 
               return(1/p/a^(z/p)*transform::mellin(g(x),x,z/p))
            elif is((p:=-p)>0)=TRUE then // 1.7 for v=0 
               return(1/p*a^(z/p)*transform::mellin(g(x),x,-z/p))
            end_if
         end_if
      end_if; break
   of "_mult" do
      for k from 1 to nops(f) do
         if not has((g:=op(f,k)),x)
	   then return(g*transform::mellin(subsop(f,k=null()),x,z))
         elif g = x then 
           return(transform::mellin(subsop(f,k=null()),x,z+1))
         elif type(g)="_power" then
            if op(g,1)=x and not has(op(g,2),x) then // formula 1.3 
               return(transform::mellin(subsop(f,k=null()),x,z+op(g,2)))
            end_if
         end_if
      end_for;
      // 1.6 and 1.7 are done by 1.3 and 1.4 or 1.5 
      if (s:=Match(f,_p(h)*ln(x)^_p(n)))<>FAIL then
         n:=subs(n,op(s)); 
         if testtype(n,Type::PosInt) then
            h:=subs(h,op(s));
            return(diff(transform::mellin(h,x,z),z$n)) // 1.8 
         end_if
      end_if; 
      break;
   of "diff" do // formula 1.9  mellin(diff(g(x), x), x, s) = - (s-1)*mellin(g(x), x, s-1)
      g:=op(f, 1):
         // should check that limit(x^(z-k-1)*diff(g,x$k),x=0)=0 for 0<=k<=n-1 
      if [op(f, 2..nops(f))] = [x $ nops(f)-1] then
         n:=nops(f)-1; 
      elif type(op(f, 2..nops(f))) = "_seqgen" and op(f, [2, 1]) = x then
         n:= op(f, [2, 2])   // f = diff(h, x $ n) with symbolic n
      else
         return(procname(args()));
      end_if;
      if domtype(n) = DOM_INT and n > 0 then
         return((-1)^n*transform::mellin(g,x,z-n)* _mult(z-k $ k = 1..n));
      end_if:
      return((-1)^n*gamma(z)/gamma(z-n)*transform::mellin(g,x,z-n))
   of "_power" do
      if op(f,2) = -1 then
         ab:= transform::TypeLinear(op(f, 1), [x]):
         if ab <> FALSE then
            [a, b]:= ab:
            if not iszero(a) then // 1/(a*x + b)
               b:= b/a:
               if not iszero(b) then // formula 2.4  
                 return(PI*b^(z-1)/sin(PI*z)/a);
               end_if;
            end_if;
         end_if;
      end_if;
   end_case;
   procname(args())
end_proc:

transform::mellin:=funcenv(transform::mellin):
transform::mellin:=slot(transform::mellin,"diff",proc()
begin
   hold(diff)(args())
end_proc):

transform::mellin:=slot(transform::mellin,"type","transform::mellin"):

// end of file 
