//      

/*++
AlgebraicConstant -- expression to test for algebraic constant expressions

This type expressions allows to test for algebraic constants.
++*/

Type::AlgebraicConstant:=

new(Type,
    "AlgebraicConstant",
    proc(t,x)
      name Type::AlgebraicConstant;
      option noDebug;
    begin
      if args(0) <> 2 then return(FALSE) end_if;
    case domtype(x)
      of DOM_IDENT do return(FALSE);
      of DOM_EXPR do
        if op(x,0) = hold(_index) then
          return(FALSE)
        elif op(x,0)=hold(_power) then
          return(testtype(op(x,1),Type::AlgebraicConstant)
                 and contains({DOM_RAT,DOM_INT},type(op(x,2))))
        elif not contains({hold(_mult), hold(_plus)}, op(x,0)) then
          // exclude expressions like sin(3) 
          return(FALSE)
        else
          t:= map([op(x)], testtype, Type::AlgebraicConstant);
        end_if;
        if contains(t, FALSE) <> 0 then return(FALSE) end_if;
        if contains(t, FAIL) <> 0 then return(FAIL) end_if;
        return(TRUE);
      of DOM_INT do
      of DOM_RAT do return(TRUE);
      of DOM_COMPLEX do
        return(bool(nops({DOM_RAT,DOM_INT} union map({op(x)},type))=2))
      of DOM_FLOAT do
      of DOM_STRING do
      of DOM_BOOL do
      of DOM_NIL do
      of DOM_NULL do
      of DOM_FAIL do
		  return(FALSE);
    end_case;
    FAIL
    end_proc,
    FALSE, FALSE):

// end of file 
