//      

/*++
  Type::Interval - the type of numbers 

++*/

Type::Interval:=
proc(l, r)
  local nrange, check;
begin
  check:=
  proc(a)
  begin
    if type(a) = DOM_LIST then
      check(a[1])
    else
      _lazy_or(a=infinity, a=-infinity, contains({DOM_RAT, DOM_INT, DOM_FLOAT}, type(a)))
    end_if
  end_proc;  
  
  
  
  nrange:= Type::Real; // default
  
  if type(l) = DOM_LIST then
    case nops(l)
    of 1 do
      break
    of 2 do 
      if args(0) > 2 then
        error("Too many arguments")
      end_if;  
      if args(0) = 2 then
        nrange:= r
      end_if;
      r:= [op(l, 2)];
      l:= [op(l, 1)];
      break
    otherwise
      error("Wrong number of operands in list")
    end_case;  
  end_if;
  
  if type(r) = DOM_LIST and nops(r) <> 1 then
    error("Wrong number of operands in list")
  end_if;
  
  if args(0) > 3 then
    error("Wrong number of arguments")
  elif args(0) = 3 then
    nrange:= args(3)
  end_if;  
  
  if not check(l) or not check(r) then
    new(Type, "Interval", FALSE, [l, r, nrange], FALSE)
  else 
    new(Type,
    "Interval",
    proc(t,x)
      name Type::Interval;
      local l, r, left, right;
    begin
      if args(0) <> 2 then return(FALSE) end_if;
      case domtype(x)
      of DOM_INT do
      of DOM_RAT do
      of DOM_FLOAT do
        
        if not testtype(x, op(t, 3)) then
          return(FALSE)
        end_if;
        if type(op(t, 1)) = DOM_LIST then
          left:= _leequal;
          l:= op(t, [1, 1])
        else
          left:= _less;
          l:= op(t, 1);
        end_if;
        if type(op(t, 2)) = DOM_LIST then
          right:= _leequal;
          r:= op(t, [2, 1])
        else
          right:= _less;
          r:= op(t, 2)
        end_if;
        
        bool(left(l, x) and right(x, r));
        break
      otherwise
        FALSE
      end_case
    end_proc,
    [l, r, nrange], FALSE
    )
    end_if
  end_proc: