/*++
Independent -- returns type expression to test for dependency

Independent(x)

x - unknown or set of unknowns

The type expression created returns TRUE if an expression is independent of x.
++*/

Type::IndepOf:=
proc(IN ={})
  option escape, noDebug;
begin
  if args(0) > 1 then
    error("Too many arguments")
  end_if;  
  
  if testargs() then
    if not testtype(IN, Type::SetOf(DOM_IDENT)) and domtype(IN) <> DOM_IDENT then
      error("wrong type of args (indet or set of indets expected)")
    end_if
  end_if;
  
  new(Type,
      "IndepOf(".expr2text(IN).")",
      proc(t,x)
	name Type::IndepOf;
        option noDebug;
        local k, n;
      begin
        if domtype(x) = DOM_EXPR then
          _and(testtype(n, Type::IndepOf(IN)) $ n in op(x))
        else
          _and(_not(has(x, k)) $ k in [IN])
        end_if
      end_proc,
      [IN], FALSE)
end_proc:

