/* tests if an expression is linear in the indeterminates in l,
   returns the list of coefficients or FALSE
   Type::Linear(a*x+b,[x]) -> [a,b]
   Type::Linear(a*x+b*y+c,[x,y]) -> [a,b,c]
   Type::Linear(a*x^2+b*y+c,[x,y]) -> FALSE

   used in ODE
*/
Type::Linear:=proc(p,l)
  option noDebug;
  local t,m,f,a,i,d,n,ff;
begin
      n:=nops(l);
      m:=[0$n+1];
      if type(p)<>"_plus" then p:=[p] end_if;
      for t in p do
         if type(t)<>"_mult" then t:=[t] end_if;
         a:=1; d:=0;
         for f in t do
            if type(f)="_power" then 
               ff:=op(f,1);
               if contains(l,ff)<>0 then return(FALSE)
               elif has(f,l) then return(FALSE)
               else a:=a*f
               end_if
            elif (i:=contains(l,f))<>0 then // f is one of the variables 
               if d=0 then d:=i else return(FALSE) end_if
            elif has(f,l) then return(FALSE) // f=cos(x) for example 
            else a:=a*f
            end_if;
         end_for;
         if d=0 then d:=n+1 end_if;
         m[d]:=m[d]+a
      end_for;
      m
end_proc:
