//      

/*++
ListProduct -- returns type expression to test products represented by lists

ListProduct(T,...)

T - type

The type expression created returns TRUE if an expression is a list
where element ei has type Ti.
++*/

Type::ListProduct:= proc()
    option noDebug;
    local i;
begin
    if testargs() then
	for i from 1 to args(0) do
	    if Type::isSeqType(args(i)) then
		error("can't test for sequences")
	    end_if
	end_for
    end_if;

    new(Type,
	"ListProduct",
	(if map({args()}, domtype) = {Type} then
	    proc(t,x)
	      name Type::ListProduct;
	      option noDebug;
	      local r, i;
	    begin
		if args(0) <> 2 then return(FALSE) end_if;
		if domtype(x) <> DOM_LIST then return(FALSE) end_if;
		if nops(x) <> nops(t) then return(FALSE) end_if;
		r:= TRUE;
		for i from 1 to nops(x) do
		    case extop(t[i],2)(extop(t[i],3), x[i])
		    of FALSE do return(FALSE);
		    of FAIL do r:= FAIL;
		    end_case;
		end_for;
		r
	    end_proc
	else
	    proc(t,x)
	      name Type::ListProduct;
	      option noDebug;
	      local r, i;
	    begin
		if args(0) <> 2 then return(FALSE) end_if;
		if domtype(x) <> DOM_LIST then return(FALSE) end_if;
		if nops(x) <> nops(t) then return(FALSE) end_if;
		r:= TRUE;
		for i from 1 to nops(x) do
		    case testtype(x[i], t[i])
		    of FALSE do return(FALSE);
		    of FAIL do r:= FAIL;
		    end_case;
		end_for;
		r
	    end_proc
	end_if),
	[ args() ], FALSE)
end_proc:

// end of file 
