//      

/*++
TableOfEntry - returns type expression to test tables

TableOfEntry(T)

T   - type of table elements

The type expression created returns TRUE if an expression is a table
with entries of type 'T'. 
++*/

Type::TableOfEntry:= proc(T)
  option noDebug;
begin
    if testargs() then
	case args(0)
	of 1 do
	    break;
	otherwise error("wrong no of args");
	end_case;
	if Type::isSeqType(T) then
	    error("can't test for sequences")
	end_if
    end_if;

    new(Type,
	"TableOfEntry",
	(if domtype(T) = Type then
	    proc(t,x)
	      name Type::TableOfEntry;
                option noDebug;
		local e, r;
	    begin
		if args(0) <> 2 then return(FALSE) end_if;
		if domtype(x) = DOM_TABLE then
		    t:= t[1];
		    r:= TRUE;
		    for e in x do
		    e := op(e,2);
			case extop(t,2)(extop(t,3), e)
			of FALSE do return(FALSE);
			of FAIL do r:= FAIL;
			end_case;
		    end_for;
		    r
		else
		    FALSE
		end_if;
	    end_proc
	else
	    proc(t,x)
	      name Type::TableOfEntry;
                option noDebug;
		local e, r;
	    begin
		if args(0) <> 2 then return(FALSE) end_if;
		if domtype(x) = DOM_TABLE then
		    t:= t[1];
		    r:= TRUE;
		    for e in x do
		    e := op(e,2);
			case testtype(e, t)
			of FALSE do return(FALSE);
			of FAIL do r:= FAIL;
			end_case;
		    end_for;
		    r
		else
		    FALSE
		end_if;
	    end_proc
	end_if),
	[ args() ], FALSE)
end_proc:

// end of file 
