//      

/*++
Union -- returns type expression to test alternative types

Union(T1, T2,...)

T1, T2 - types

The type expression created returns TRUE if an expression has one
of the given types.
++*/

Type::Union:=
  proc()
    option noDebug;
    local a, s, e;
  begin
    a:= {args()};
    case nops(a)
      of 0 do error("wrong no of args")
      of 1 do return(op(a))
    end_case;
    
    // test if one of the type arguments is a sequence type 
    s:= FALSE;
    for e in a do
      if Type::isSeqType(e) then s:= TRUE; break end_if
    end_for;
    
    new(Type,
        "Union",
        (if map(a, domtype) = {Type} then
	   proc(t)
	     name Type::Union;
             option noDebug;
             local e, r, i, x;
           begin
             x:= args(i) $ i=2..args(0);
             r:= FALSE;
             for e in t do
               case extop(e,2)(extop(e,3), x)
                 of TRUE do return(TRUE);
                 of FAIL do r:= FAIL;
               end_case;
         end_for;
         r
         end_proc
         else
         proc(t)
	   name Type::Union;
           option noDebug;
           local e, r, i,x;
         begin
           x:= args(i) $ i=2..args(0);
           r:= FALSE;
           for e in t do
             case testtype(x, e)
               of TRUE do
                 return(TRUE);
               of FAIL do
                 r:= FAIL;
             end_case;
         end_for;
         r
         end_proc
         end_if),
        a, s)
  end_proc:
